/**
* \file: AlsaAudioOut.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "AlsaAudioOut.h"
#include "AlsaAudioOutImpl.h"

using namespace std;

namespace adit { namespace carplay
{

AlsaAudioOut::AlsaAudioOut()
{
    impl = new Impl();
}

AlsaAudioOut::~AlsaAudioOut()
{
    delete impl;
}

bool AlsaAudioOut::Initialize(const IConfiguration& inConfig, IAudioOutSource& inSource)
{
    return impl->Initialize(inConfig, inSource);
}

bool AlsaAudioOut::Prepare(AudioFormatStruct inFormat, AudioChannelType inChannel,
        const std::string& inAudioType)
{
    return impl->Prepare(inFormat, inChannel, inAudioType);
}

bool AlsaAudioOut::Start()
{
    return impl->Start();
}

void AlsaAudioOut::Stop()
{
    impl->Stop();
}

void AlsaAudioOut::Flush()
{
    impl->Flush();
}

} } // namespace adit { namespace carplay
